from utils import Gtk, Adw, EINHEITEN, partial, show_message, confirm
from datetime import datetime
from stammdaten import update_master_data_dropdowns

def create_verkauf_page(window):
    page = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=20)
    page.set_margin_start(40); page.set_margin_end(40)
    page.set_margin_top(40); page.set_margin_bottom(40)

    header = Gtk.Label(label="Verkauf erfassen"); header.add_css_class('title-2'); header.set_halign(Gtk.Align.START); page.append(header)
    form = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=15)

    datum_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    datum_label = Gtk.Label(label="Datum:"); datum_label.set_size_request(150, -1); datum_label.set_halign(Gtk.Align.START)
    window.verkauf_datum = Gtk.Entry(); window.verkauf_datum.set_text(datetime.now().strftime('%Y-%m-%d'))
    datum_box.append(datum_label); datum_box.append(window.verkauf_datum); form.append(datum_box)

    artikel_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    artikel_label = Gtk.Label(label="Artikel:"); artikel_label.set_size_request(150, -1); artikel_label.set_halign(Gtk.Align.START)
    window.verkauf_artikel_dd = Gtk.DropDown()
    window.verkauf_artikel_dd.set_enable_search(True)
    window.verkauf_artikel_dd.connect('notify::selected', partial(on_verkauf_artikel_selected, window))
    artikel_box.append(artikel_label); artikel_box.append(window.verkauf_artikel_dd); form.append(artikel_box)

    menge_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    menge_label = Gtk.Label(label="Menge:"); menge_label.set_size_request(150, -1); menge_label.set_halign(Gtk.Align.START)
    window.verkauf_menge = Gtk.SpinButton(); window.verkauf_menge.set_adjustment(Gtk.Adjustment(value=1, lower=0.0001, upper=1000000, step_increment=1))
    window.verkauf_einheit = Gtk.DropDown(); window.verkauf_einheit.set_model(Gtk.StringList.new(EINHEITEN)); window.verkauf_einheit.set_selected(0)
    menge_box.append(menge_label); menge_box.append(window.verkauf_menge); menge_box.append(window.verkauf_einheit); form.append(menge_box)

    preis_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    preis_label = Gtk.Label(label="Verkaufspreis (€ pro Einheit):"); preis_label.set_size_request(150, -1); preis_label.set_halign(Gtk.Align.START)
    window.verkauf_preis = Gtk.Entry(); window.verkauf_preis.set_text("0.00")
    preis_box.append(preis_label); preis_box.append(window.verkauf_preis); form.append(preis_box)

    steuer_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    steuer_label = Gtk.Label(label="Steuersatz:"); steuer_label.set_size_request(150, -1); steuer_label.set_halign(Gtk.Align.START)
    window.verkauf_steuer = Gtk.DropDown(); window.verkauf_steuer.set_model(Gtk.StringList.new(["7%", "19%"])); window.verkauf_steuer.set_selected(1)
    steuer_box.append(steuer_label); steuer_box.append(window.verkauf_steuer); form.append(steuer_box)

    kunde_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    kunde_label = Gtk.Label(label="Kunde:"); kunde_label.set_size_request(150, -1); kunde_label.set_halign(Gtk.Align.START)
    window.verkauf_kunde_dd = Gtk.DropDown()
    window.verkauf_kunde_dd.set_enable_search(True)
    kunde_box.append(kunde_label); kunde_box.append(window.verkauf_kunde_dd); form.append(kunde_box)

    page.append(form)

    btn = Gtk.Button(label="Verkauf speichern"); btn.add_css_class('suggested-action'); btn.set_size_request(200, -1)
    btn.connect('clicked', partial(on_verkauf_save, window)); page.append(btn)

    window.content_stack.add_named(page, 'verkauf')

def on_verkauf_artikel_selected(window, dropdown, param):
    selected = dropdown.get_selected()
    if selected == Gtk.INVALID_LIST_POSITION:
        return
    model = dropdown.get_model()
    artikel_name = model.get_string(selected)
    artikel = next((a for a in window.app.data['stammdaten']['artikel'] if a['name'] == artikel_name), None)
    if artikel:
        try:
            window.verkauf_preis.set_text(f"{float(artikel.get('vk_preis', 0.0)):.2f}".replace('.', ','))
        except Exception:
            pass
        einheit = artikel.get('einheit')
        if einheit in EINHEITEN:
            window.verkauf_einheit.set_selected(EINHEITEN.index(einheit))

def on_verkauf_save(window, button):
    try:
        datum = window.verkauf_datum.get_text()
        artikel_idx = window.verkauf_artikel_dd.get_selected()
        if artikel_idx == Gtk.INVALID_LIST_POSITION:
            show_message(window, "Fehler", "Bitte einen Artikel auswählen."); return
        artikel = window.verkauf_artikel_dd.get_model().get_string(artikel_idx)
        menge = float(window.verkauf_menge.get_value())
        preis = float(window.verkauf_preis.get_text().replace(',', '.'))
        steuer = 7 if window.verkauf_steuer.get_selected() == 0 else 19
        kunde_idx = window.verkauf_kunde_dd.get_selected()
        if kunde_idx == Gtk.INVALID_LIST_POSITION:
            kunde = ""
        else:
            kunde = window.verkauf_kunde_dd.get_model().get_string(kunde_idx)
        einheit = EINHEITEN[window.verkauf_einheit.get_selected()]

        if not artikel:
            show_message(window, "Fehler", "Bitte Artikel auswählen."); return

        bestand_item = next((b for b in window.app.data['bestand'] if b['artikel'] == artikel), None)
        if not bestand_item or bestand_item['menge'] < menge:
            show_message(window, "Fehler", "Nicht genug Bestand vorhanden"); return

        verkauf = {
            'datum': datum, 'artikel': artikel, 'menge': menge, 'einheit': einheit,
            'preis': preis, 'steuer': steuer, 'kunde': kunde, 'gesamt': round(menge * preis, 2)
        }
        window.app.data['verkäufe'].append(verkauf)
        bestand_item['menge'] -= menge
        if 'einheit' not in bestand_item or not bestand_item['einheit']:
            bestand_item['einheit'] = einheit

        window.app.save_data()
        show_message(window, "Erfolg", "Verkauf gespeichert")
        window.verkauf_menge.set_value(1); window.verkauf_preis.set_text("0.00")
        window.verkauf_artikel_dd.set_selected(Gtk.INVALID_LIST_POSITION)
        window.verkauf_kunde_dd.set_selected(Gtk.INVALID_LIST_POSITION)
        update_verkauf_jahr_filter(window) # NEU
        refresh_verkauf_list(window)
        from bestand import refresh_bestand_list
        refresh_bestand_list(window)
        from kassenbuch import refresh_kassenbuch
        refresh_kassenbuch(window)
    except ValueError:
        show_message(window, "Fehler", "Bitte gültige Zahlen eingeben")

def create_verkauf_list_page(window):
    page = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=20)
    page.set_margin_start(40); page.set_margin_end(40)
    page.set_margin_top(40); page.set_margin_bottom(40)
    header = Gtk.Label(label="Verkäufe"); header.add_css_class('title-2'); header.set_halign(Gtk.Align.START); page.append(header)

    # Filter Container
    filters_container = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=10)

    # Text-Filter
    filter_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    filter_label = Gtk.Label(label="Suchen:")
    window.verkauf_filter = Gtk.Entry(); window.verkauf_filter.set_placeholder_text("Artikel, Kunde, Re-Nr...")
    window.verkauf_filter.connect('changed', lambda e: refresh_verkauf_list(window))
    filter_box.append(filter_label); filter_box.append(window.verkauf_filter)
    filters_container.append(filter_box)

    # NEU: Datums-Filter
    date_filter_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    date_filter_label = Gtk.Label(label="Datum:")
    window.verkauf_filter_jahr = Gtk.DropDown()
    window.verkauf_filter_jahr.connect("notify::selected", lambda d, p: refresh_verkauf_list(window))
    monate = ["Alle Monate"] + [f"{i:02d}" for i in range(1, 13)]
    window.verkauf_filter_monat = Gtk.DropDown.new_from_strings(monate)
    window.verkauf_filter_monat.connect("notify::selected", lambda d, p: refresh_verkauf_list(window))
    date_filter_box.append(date_filter_label)
    date_filter_box.append(window.verkauf_filter_jahr)
    date_filter_box.append(window.verkauf_filter_monat)
    filters_container.append(date_filter_box)

    page.append(filters_container)

    scrolled = Gtk.ScrolledWindow(); scrolled.set_vexpand(True); scrolled.set_policy(Gtk.PolicyType.NEVER, Gtk.PolicyType.AUTOMATIC)
    window.verkauf_list_box = Gtk.ListBox(); window.verkauf_list_box.add_css_class('boxed-list')
    scrolled.set_child(window.verkauf_list_box); page.append(scrolled)
    window.content_stack.add_named(page, 'verkauf_list')

    update_verkauf_jahr_filter(window)

# NEU: Funktion zum Füllen des Jahres-Dropdowns
def update_verkauf_jahr_filter(window):
    if not hasattr(window, 'verkauf_filter_jahr'): return
    
    jahre = {"Alle Jahre"}
    for verkauf in window.app.data.get("verkäufe", []):
        try:
            jahre.add(verkauf["datum"][:4])
        except (IndexError, TypeError, KeyError):
            continue

    jahre_liste = sorted(list(jahre), reverse=True)
    if "Alle Jahre" in jahre_liste:
        jahre_liste.remove("Alle Jahre")
        jahre_liste.insert(0, "Alle Jahre")

    selected_index = window.verkauf_filter_jahr.get_selected()
    selected_value = None
    if selected_index > 0 and window.verkauf_filter_jahr.get_model():
        selected_value = window.verkauf_filter_jahr.get_model().get_string(selected_index)

    window.verkauf_filter_jahr.set_model(Gtk.StringList.new(jahre_liste))

    if selected_value and selected_value in jahre_liste:
        window.verkauf_filter_jahr.set_selected(jahre_liste.index(selected_value))
    else:
        window.verkauf_filter_jahr.set_selected(0)

def refresh_verkauf_list(window):
    if not hasattr(window, 'verkauf_list_box'): return
    while True:
        row = window.verkauf_list_box.get_row_at_index(0)
        if row is None: break
        window.verkauf_list_box.remove(row)

    # Filter-Werte auslesen
    filter_text = window.verkauf_filter.get_text().lower() if hasattr(window, 'verkauf_filter') else ""

    model_jahr = window.verkauf_filter_jahr.get_model() if hasattr(window, 'verkauf_filter_jahr') else None
    selected_jahr_index = window.verkauf_filter_jahr.get_selected() if hasattr(window, 'verkauf_filter_jahr') else 0
    filter_jahr = (
        model_jahr.get_string(selected_jahr_index)
        if model_jahr and selected_jahr_index != Gtk.INVALID_LIST_POSITION
        else "Alle Jahre"
    )

    selected_monat_index = window.verkauf_filter_monat.get_selected() if hasattr(window, 'verkauf_filter_monat') else 0
    filter_monat = f"{selected_monat_index:02d}" if selected_monat_index > 0 else "Alle Monate"
    
    for verkauf in reversed(window.app.data['verkäufe']):
        # Datums-Filter anwenden
        try:
            if filter_jahr != "Alle Jahre" and not str(verkauf["datum"]).startswith(filter_jahr):
                continue
            if filter_monat != "Alle Monate" and str(verkauf["datum"])[5:7] != filter_monat:
                continue
        except Exception:
            pass

        # Text-Filter anwenden
        haystack = (
            str(verkauf.get("artikel", "")).lower() + " " +
            str(verkauf.get("kunde", "")).lower() + " " +
            str(verkauf.get("rechnung_nr", "")).lower()
        )
        if filter_text and filter_text not in haystack:
            continue

        row = Gtk.ListBoxRow()
        box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=5)
        box.set_margin_start(10); box.set_margin_end(10); box.set_margin_top(10); box.set_margin_bottom(10)
        header_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL)
        title = Gtk.Label(label=f"{verkauf['artikel']} - {verkauf['menge']} {verkauf['einheit']}"); title.add_css_class('heading')
        title.set_halign(Gtk.Align.START); title.set_hexpand(True); header_box.append(title)
        preis_label = Gtk.Label(label=f"{verkauf['gesamt']:.2f} €"); preis_label.add_css_class('title-3'); header_box.append(preis_label)
        box.append(header_box)
        
        re_nr_text = f" | Re-Nr: {verkauf.get('rechnung_nr')}" if verkauf.get('rechnung_nr') else ''
        details_text = f"{verkauf['datum']} | {verkauf['preis']:.4f} €/Einheit | MwSt: {verkauf['steuer']}% | {verkauf.get('kunde', '')}{re_nr_text}"
        details = Gtk.Label(label=details_text)
        details.add_css_class('dim-label'); details.set_halign(Gtk.Align.START); box.append(details)

        # Buttons für Bearbeiten und Löschen
        button_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
        btn_edit = Gtk.Button(label="Bearbeiten")
        btn_edit.add_css_class('flat')
        btn_edit.connect('clicked', partial(open_verkauf_editor, window, verkauf))
        btn_del = Gtk.Button(label="Löschen")
        btn_del.add_css_class('destructive-action')
        btn_del.add_css_class('flat')
        btn_del.connect('clicked', partial(delete_verkauf, window, verkauf))
        button_box.append(btn_edit)
        button_box.append(btn_del)
        box.append(button_box)

        row.set_child(box); window.verkauf_list_box.append(row)

def open_verkauf_editor(window, verkauf, _btn=None):
    dlg = Adw.MessageDialog.new(window, "Verkauf bearbeiten", "Bearbeiten Sie den Verkauf.")
    dlg.add_response("cancel", "Abbrechen")
    dlg.add_response("save", "Speichern")
    dlg.set_response_appearance("save", Adw.ResponseAppearance.SUGGESTED)

    content = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=12)
    content.set_margin_start(16); content.set_margin_end(16); content.set_margin_top(16); content.set_margin_bottom(16)

    def create_dialog_row(label_text, widget):
        row_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
        label = Gtk.Label(label=label_text)
        label.set_size_request(150, -1); label.set_halign(Gtk.Align.START)
        row_box.append(label)
        if isinstance(widget, list):
            for w in widget:
                row_box.append(w)
        else:
            row_box.append(widget)
        content.append(row_box)

    # Felder erstellen
    datum_entry = Gtk.Entry(); datum_entry.set_text(verkauf.get('datum', ''))
    create_dialog_row("Datum:", datum_entry)

    artikel_namen = [a['name'] for a in window.app.data['stammdaten']['artikel']]
    dd_artikel_model = Gtk.StringList.new(artikel_namen)
    dd_artikel = Gtk.DropDown(); dd_artikel.set_model(dd_artikel_model); dd_artikel.set_enable_search(True)
    try:
        dd_artikel.set_selected(artikel_namen.index(verkauf.get('artikel', '')))
    except ValueError:
        pass
    create_dialog_row("Artikel:", dd_artikel)

    menge_spin = Gtk.SpinButton(); menge_spin.set_adjustment(Gtk.Adjustment(value=verkauf.get('menge', 1.0), lower=0.0001, upper=1000000, step_increment=1))
    einheit_dd = Gtk.DropDown.new_from_strings(EINHEITEN)
    try:
        einheit_dd.set_selected(EINHEITEN.index(verkauf.get('einheit', 'Stück')))
    except ValueError:
        einheit_dd.set_selected(0)
    create_dialog_row("Menge:", [menge_spin, einheit_dd])

    preis_entry = Gtk.Entry(); preis_entry.set_text(f"{verkauf.get('preis', 0.0):.4f}".replace('.', ','))
    create_dialog_row("Verkaufspreis (€ pro Einheit):", preis_entry)

    steuer_dd = Gtk.DropDown.new_from_strings(["7%", "19%"])
    steuer = verkauf.get('steuer', 19)
    steuer_dd.set_selected(0 if steuer == 7 else 1)
    create_dialog_row("Steuersatz:", steuer_dd)

    kunden_namen = [k['name'] for k in window.app.data['stammdaten']['kunden']]
    dd_kunde_model = Gtk.StringList.new(kunden_namen)
    dd_kunde = Gtk.DropDown(); dd_kunde.set_model(dd_kunde_model); dd_kunde.set_enable_search(True)
    try:
        dd_kunde.set_selected(kunden_namen.index(verkauf.get('kunde', '')))
    except ValueError:
        pass
    create_dialog_row("Kunde:", dd_kunde)

    dlg.set_extra_child(content)

    def on_resp(d, resp):
        if resp == "save":
            try:
                new_datum = datum_entry.get_text()
                new_art_idx = dd_artikel.get_selected()
                if new_art_idx == Gtk.INVALID_LIST_POSITION:
                    show_message(window, "Fehler", "Bitte einen Artikel auswählen.")
                    return
                new_artikel = dd_artikel.get_model().get_string(new_art_idx)
                new_menge = float(menge_spin.get_value())
                new_preis = float(preis_entry.get_text().replace(',', '.'))
                new_steuer = 7 if steuer_dd.get_selected() == 0 else 19
                new_kunde_idx = dd_kunde.get_selected()
                if new_kunde_idx == Gtk.INVALID_LIST_POSITION:
                    new_kunde = ""
                else:
                    new_kunde = dd_kunde.get_model().get_string(new_kunde_idx)
                new_einheit = EINHEITEN[einheit_dd.get_selected()]

                # Alte Werte speichern
                old_artikel = verkauf['artikel']
                old_menge = verkauf.get('menge', 0.0)

                # Prüfe Bestand für neue Werte
                new_bestand_item = next((b for b in window.app.data['bestand'] if b['artikel'] == new_artikel), None)
                if not new_bestand_item or new_bestand_item['menge'] < new_menge:
                    show_message(window, "Fehler", "Nicht genug Bestand vorhanden.")
                    return

                # Update Verkauf
                verkauf['datum'] = new_datum
                verkauf['artikel'] = new_artikel
                verkauf['menge'] = new_menge
                verkauf['einheit'] = new_einheit
                verkauf['preis'] = new_preis
                verkauf['steuer'] = new_steuer
                verkauf['kunde'] = new_kunde
                verkauf['gesamt'] = round(new_menge * new_preis, 2)

                # Bestand anpassen
                if old_artikel != new_artikel:
                    # Alten Artikel zurückgeben
                    old_bestand = next((b for b in window.app.data['bestand'] if b['artikel'] == old_artikel), None)
                    if old_bestand:
                        old_bestand['menge'] += old_menge
                    # Neuen Artikel abziehen
                    new_bestand_item['menge'] -= new_menge
                    if new_bestand_item['menge'] <= 0:
                        window.app.data['bestand'].remove(new_bestand_item)
                else:
                    # Gleicher Artikel: Delta anpassen
                    bestand_item = next((b for b in window.app.data['bestand'] if b['artikel'] == new_artikel), None)
                    if bestand_item:
                        bestand_item['menge'] += (old_menge - new_menge)
                        if bestand_item['menge'] <= 0:
                            window.app.data['bestand'].remove(bestand_item)

                window.app.save_data()
                update_verkauf_jahr_filter(window) # NEU
                refresh_verkauf_list(window)
                from bestand import refresh_bestand_list
                refresh_bestand_list(window)
                from kassenbuch import refresh_kassenbuch
                refresh_kassenbuch(window)
                show_message(window, "Erfolg", "Verkauf aktualisiert")
            except ValueError:
                show_message(window, "Fehler", "Bitte gültige Zahlen eingeben.")
        d.close()

    dlg.connect("response", on_resp)
    dlg.present()

def delete_verkauf(window, verkauf, _btn=None):
    if confirm(window, "Löschen bestätigen", f"Verkauf vom {verkauf.get('datum', '')} wirklich löschen?"):
        index = window.app.data['verkäufe'].index(verkauf)
        del window.app.data['verkäufe'][index]
        # Bestand anpassen (Menge zurückgeben)
        bestand_item = next((b for b in window.app.data['bestand'] if b['artikel'] == verkauf['artikel']), None)
        if bestand_item:
            bestand_item['menge'] += verkauf.get('menge', 0.0)
            if 'einheit' not in bestand_item or not bestand_item['einheit']:
                bestand_item['einheit'] = verkauf.get('einheit', '')
        window.app.save_data()
        update_verkauf_jahr_filter(window) # NEU
        refresh_verkauf_list(window)
        from bestand import refresh_bestand_list
        refresh_bestand_list(window)
        from kassenbuch import refresh_kassenbuch
        refresh_kassenbuch(window)
        show_message(window, "Erfolg", "Verkauf gelöscht")