from utils import Gtk, Adw, partial, show_message, confirm


def create_sperrliste_page(window):
    page = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=20)
    page.set_margin_start(40)
    page.set_margin_end(40)
    page.set_margin_top(40)
    page.set_margin_bottom(40)

    header = Gtk.Label(label="Sperrliste")
    header.add_css_class("title-2")
    header.set_halign(Gtk.Align.START)
    page.append(header)

    # Filter
    filter_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    filter_label = Gtk.Label(label="Filter:")
    window.sperr_filter = Gtk.Entry()
    window.sperr_filter.set_placeholder_text("Artikel, Lieferant, Re-Nr oder Bemerkung…")
    window.sperr_filter.connect("changed", lambda e: refresh_sperrliste_list(window))
    filter_box.append(filter_label)
    filter_box.append(window.sperr_filter)
    page.append(filter_box)

    scrolled = Gtk.ScrolledWindow()
    scrolled.set_vexpand(True)
    scrolled.set_policy(Gtk.PolicyType.NEVER, Gtk.PolicyType.AUTOMATIC)
    window.sperrliste_list_box = Gtk.ListBox()
    window.sperrliste_list_box.add_css_class("boxed-list")
    scrolled.set_child(window.sperrliste_list_box)
    page.append(scrolled)

    window.content_stack.add_named(page, "sperrliste")


def refresh_sperrliste_list(window):
    if not hasattr(window, "sperrliste_list_box"):
        return

    # Liste leeren
    while True:
        row = window.sperrliste_list_box.get_row_at_index(0)
        if not row:
            break
        window.sperrliste_list_box.remove(row)

    filter_text = window.sperr_filter.get_text().lower() if hasattr(window, "sperr_filter") else ""

    for item in reversed(window.app.data.get("sperrliste", [])):
        # Filter anwenden
        if filter_text:
            hay = " ".join(
                [
                    str(item.get("artikel", "")),
                    str(item.get("lieferant", "")),
                    str(item.get("rechnungs_nr", "")),
                    str(item.get("bemerkung", "")),
                    str(item.get("entscheidung", "") or item.get("status", "")),
                ]
            ).lower()
            if filter_text not in hay:
                continue

        row = Gtk.ListBoxRow()
        box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=5)
        box.set_margin_start(10)
        box.set_margin_end(10)
        box.set_margin_top(10)
        box.set_margin_bottom(10)

        # Kopfzeile
        header = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
        title = Gtk.Label(label=f"{item.get('artikel','')} – {item.get('menge',0)} {item.get('einheit','')}")
        title.add_css_class("heading")
        title.set_halign(Gtk.Align.START)
        title.set_hexpand(True)
        header.append(title)

        status_badge = Gtk.Label(label=item.get("entscheidung") or item.get("status", "Gesperrt"))
        status_badge.add_css_class("dim-label")
        header.append(status_badge)
        box.append(header)

        # Details
        netto = float(item.get("preis_netto", 0) or 0)
        steuer = int(item.get("steuer", 0) or 0)
        details_text = (
            f"{item.get('datum','')} | Re-Nr: {item.get('rechnungs_nr','k.A.')} | "
            f"{item.get('lieferant','')} | Netto: {netto:.4f}€ | Steuer: {steuer}%"
        )
        details = Gtk.Label(label=details_text)
        details.add_css_class("dim-label")
        details.set_halign(Gtk.Align.START)
        box.append(details)

        if item.get("bemerkung"):
            remark = Gtk.Label(label=f"Bemerkung: {item.get('bemerkung')}")
            remark.set_halign(Gtk.Align.START)
            box.append(remark)

        # Aktionen
        buttons = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
        btn_edit = Gtk.Button(label="Bearbeiten")
        btn_edit.add_css_class("flat")
        btn_edit.connect("clicked", partial(open_sperr_editor, window, item))

        btn_del = Gtk.Button(label="Eintrag entfernen")
        btn_del.add_css_class("destructive-action")
        btn_del.add_css_class("flat")
        btn_del.connect("clicked", partial(delete_sperr_entry, window, item))

        buttons.append(btn_edit)
        buttons.append(btn_del)
        box.append(buttons)

        row.set_child(box)
        window.sperrliste_list_box.append(row)


def open_sperr_editor(window, item, _btn=None):
    dlg = Adw.MessageDialog.new(window, "Sperreintrag bearbeiten", "Status/Bemerkung anpassen.")
    dlg.add_response("cancel", "Abbrechen")
    dlg.add_response("save", "Speichern")
    dlg.set_response_appearance("save", Adw.ResponseAppearance.SUGGESTED)

    content = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=12)
    content.set_margin_start(16)
    content.set_margin_end(16)
    content.set_margin_top(16)
    content.set_margin_bottom(16)

    # Entscheidung
    row1 = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    l1 = Gtk.Label(label="Aktion:")
    l1.set_size_request(150, -1)
    l1.set_halign(Gtk.Align.START)
    entscheidungen = ["Freigabe", "Rücksendung", "Sonstiges"]
    dd = Gtk.DropDown.new_from_strings(entscheidungen)
    try:
        dd.set_selected(entscheidungen.index(item.get("entscheidung") or "Freigabe"))
    except ValueError:
        dd.set_selected(0)
    row1.append(l1)
    row1.append(dd)

    # Bemerkung
    row2 = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    l2 = Gtk.Label(label="Bemerkung:")
    l2.set_size_request(150, -1)
    l2.set_halign(Gtk.Align.START)
    entry_bem = Gtk.Entry()
    entry_bem.set_hexpand(True)
    entry_bem.set_text(item.get("bemerkung", ""))
    row2.append(l2)
    row2.append(entry_bem)

    content.append(row1)
    content.append(row2)
    dlg.set_extra_child(content)

    def on_resp(d, resp):
        if resp == "save":
            new_action = ["Freigabe", "Rücksendung", "Sonstiges"][dd.get_selected()]
            new_bem = entry_bem.get_text()

            # Update Sperr-Item
            item["entscheidung"] = new_action
            item["bemerkung"] = new_bem

            # Bei Freigabe: Bestand buchen, Einkauf-Status setzen und aus Sperrliste entfernen
            if new_action == "Freigabe":
                uid = item.get("uid")
                einkauf = next((e for e in window.app.data["einkäufe"] if e.get("uid") == uid), None)
                if einkauf:
                    einkauf["status"] = "Freigabe"
                    einkauf["bemerkung"] = new_bem

                # In den Bestand buchen
                artikel = item.get("artikel")
                if artikel:
                    menge = float(item.get("menge", 0.0) or 0.0)
                    preis_netto = float(item.get("preis_netto", 0.0) or 0.0)
                    bestand_item = next((b for b in window.app.data["bestand"] if b["artikel"] == artikel), None)
                    if bestand_item:
                        bestand_item["menge"] += menge
                        if not bestand_item.get("einheit"):
                            bestand_item["einheit"] = item.get("einheit", "")
                        bestand_item["preis"] = preis_netto
                    else:
                        window.app.data["bestand"].append(
                            {
                                "artikel": artikel,
                                "menge": menge,
                                "preis": preis_netto,
                                "einheit": item.get("einheit", ""),
                            }
                        )

                # Aus Sperrliste entfernen
                if item in window.app.data.get("sperrliste", []):
                    window.app.data["sperrliste"].remove(item)

            window.app.save_data()
            refresh_sperrliste_list(window)
            try:
                from einkauf import refresh_einkauf_list
                from bestand import refresh_bestand_list
                from kassenbuch import refresh_kassenbuch

                refresh_einkauf_list(window)
                refresh_bestand_list(window)
                refresh_kassenbuch(window)
            except Exception:
                pass
            show_message(window, "Erfolg", "Sperreintrag aktualisiert")
        d.close()

    dlg.connect("response", on_resp)
    dlg.present()


def delete_sperr_entry(window, item, _btn=None):
    if confirm(
        window,
        "Eintrag entfernen?",
        "Diesen Eintrag aus der Sperrliste entfernen? Dies bucht NICHT automatisch in den Bestand.",
    ):
        if item in window.app.data.get("sperrliste", []):
            window.app.data["sperrliste"].remove(item)
            # Einkauf-Status (falls vorhanden) markieren
            uid = item.get("uid")
            einkauf = next((e for e in window.app.data["einkäufe"] if e.get("uid") == uid), None)
            if einkauf and str(einkauf.get("status", "")).startswith("Gesperrt"):
                einkauf["status"] = "Gesperrt (entfernt)"
            window.app.save_data()
            refresh_sperrliste_list(window)
            show_message(window, "Erfolg", "Eintrag entfernt")
