#!/bin/bash

echo ">>> Kassenbuch Universal Installations-Skript <<<"
echo "Versuche, die Linux-Distribution zu erkennen..."

# --- Schritt 1: Distribution erkennen und System-Pakete installieren ---

# Überprüfe, ob die /etc/os-release Datei existiert
if [ -f /etc/os-release ]; then
    # Lese die ID der Distribution aus (ID_LIKE hilft bei Derivaten wie Manjaro/Mint)
    . /etc/os-release
else
    echo "Fehler: /etc/os-release nicht gefunden. Kann die Distribution nicht bestimmen."
    exit 1
fi

# Führe die spezifischen Befehle für die erkannte Distribution aus
if [[ "$ID" == "debian" || "$ID" == "ubuntu" || "$ID_LIKE" == "debian" ]]; then
    echo "--> Debian/Ubuntu-basiertes System erkannt."
    echo "--> Installiere Abhängigkeiten via APT (sudo-Passwort wird benötigt)..."
    sudo apt update
    sudo apt install -y python3 python3-pip python3-gi python3-gi-cairo gir1.2-gtk-4.0 gir1.2-adw-1 python3-reportlab python3-lxml

elif [ "$ID" == "void" ]; then
    echo "--> Void Linux erkannt."
    echo "--> Installiere Abhängigkeiten via XBPS (sudo-Passwort wird benötigt)..."
    sudo xbps-install -Sy python3 python3-pip python3-gobject gtk4 libadwaita python3-reportlab python3-lxml

elif [ "$ID" == "fedora" ]; then
    echo "--> Fedora erkannt."
    echo "--> Installiere Abhängigkeiten via DNF (sudo-Passwort wird benötigt)..."
    sudo dnf install -y python3 python3-pip python3-gobject gtk4 libadwaita python3-reportlab python3-lxml

elif [[ "$ID" == "arch" || "$ID_LIKE" == "arch" ]]; then
    echo "--> Arch Linux-basiertes System erkannt."
    echo "--> Installiere Abhängigkeiten via Pacman (sudo-Passwort wird benötigt)..."
    sudo pacman -Syu --noconfirm
    sudo pacman -S --noconfirm python python-pip python-gobject gtk4 libadwaita python-reportlab python-lxml

elif [[ "$ID" == "opensuse-tumbleweed" || "$ID" == "opensuse-leap" || "$ID_LIKE" == "suse" ]]; then
    echo "--> openSUSE erkannt."
    echo "--> Installiere Abhängigkeiten via Zypper (sudo-Passwort wird benötigt)..."
    sudo zypper refresh
    sudo zypper install -y python3-pip python3-gobject typelib-1_0-Gtk-4_0 typelib-1_0-Adw-1 python3-reportlab python3-lxml

elif [ "$ID" == "solus" ]; then
    echo "--> Solus erkannt."
    echo "--> Installiere Abhängigkeiten via eopkg (sudo-Passwort wird benötigt)..."
    sudo eopkg install -y python3 python-gobject libgtk-4 libadwaita python-reportlab python-lxml

else
    echo "Fehler: Diese Distribution ($ID) wird vom Skript nicht automatisch unterstützt."
    echo "Bitte installiere die Abhängigkeiten manuell (GTK4, Adwaita, PyGObject, ReportLab, lxml)."
    exit 1
fi

# --- Schritt 2: Distributions-unabhängige Python-Pakete installieren ---

echo "--> Installiere 'factur-x' für den aktuellen Benutzer via pip..."
# Das ist für alle Systeme gleich, da 'factur-x' in den Repositories fehlt
pip install --user --break-system-packages factur-x

# --- Schritt 3: Lokale Skripte und Starter einrichten (für alle gleich) ---

echo "--> Mache Start-Skript ausführbar..."
chmod +x start.sh

echo "--> Erstelle und installiere Anwendungs-Starter..."
# Ermittelt den Pfad, in dem das Skript ausgeführt wird, automatisch
APP_DIR=$(pwd)
# Definiert den Zielpfad für den Starter
DESKTOP_FILE=~/.local/share/applications/kassenbuch.desktop

# Erstellt die .desktop Datei mit den korrekten Pfaden
cat << EOF > "$DESKTOP_FILE"
[Desktop Entry]
Version=1.0
Type=Application
Name=Kassenbuch
Comment=Einfaches Kassenbuch Programm
Exec=$APP_DIR/start.sh
Icon=$APP_DIR/icons/app_icon.png
Terminal=false
Categories=Office;Finance;
EOF

echo ""
echo ">>> Installation abgeschlossen! <<<"
echo "Du solltest 'Kassenbuch' jetzt in deinem Anwendungsmenü finden."
echo "(Eventuell musst du dich ab- und wieder anmelden, damit es erscheint.)"
