from utils import Gtk, Adw, EINHEITEN, partial, show_message, confirm

def create_stammdaten_page(window):
    page = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=20)
    page.set_margin_start(30); page.set_margin_end(30); page.set_margin_top(30); page.set_margin_bottom(30)
    header = Gtk.Label(label="Stammdaten"); header.add_css_class('title-2'); header.set_halign(Gtk.Align.START); page.append(header)
    notebook = Gtk.Notebook(); notebook.set_tab_pos(Gtk.PositionType.TOP); page.append(notebook)
    
    def field_row(label, widget):
        hb = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
        l = Gtk.Label(label=label); l.set_size_request(160, -1); l.set_halign(Gtk.Align.START)
        hb.append(l); hb.append(widget); return hb
        
    def create_tab_content(field_labels):
        box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=12)
        box.set_margin_start(10); box.set_margin_end(10); box.set_margin_top(10); box.set_margin_bottom(10)
        entries = {}
        for key, label in field_labels.items():
            entries[key] = Gtk.Entry()
            box.append(field_row(label, entries[key]))
        return box, entries

    # Firma Tab
    firma_box, window.firma_entries = create_tab_content({
        'name': "Name:", 'strasse': "Straße:", 'plz': "PLZ:", 'ort': "Ort:", 
        'email': "E-Mail:", 'telefon': "Telefon:",
        'bank': "Bank:", 'iban': "IBAN:", 'bic': "BIC:"
    })
    save_firma_btn = Gtk.Button(label="Firma speichern"); save_firma_btn.add_css_class('suggested-action')
    save_firma_btn.connect('clicked', partial(on_save_firma, window)); firma_box.append(save_firma_btn)
    notebook.append_page(firma_box, Gtk.Label(label="Firma"))

    # Artikel Tab
    artikel_box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=12)
    artikel_box.set_margin_start(10); artikel_box.set_margin_end(10); artikel_box.set_margin_top(10); artikel_box.set_margin_bottom(10)
    window.art_nr = Gtk.Entry(); window.art_name = Gtk.Entry(); window.art_vk = Gtk.Entry(); window.art_vk.set_text("0.00")
    window.art_einheit = Gtk.DropDown.new_from_strings(EINHEITEN); window.art_einheit.set_selected(0)
    artikel_box.append(field_row("Artikelnummer:", window.art_nr))
    artikel_box.append(field_row("Artikelname:", window.art_name))
    row_vk = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    l_vk = Gtk.Label(label="VK-Preis (€):"); l_vk.set_size_request(160, -1); l_vk.set_halign(Gtk.Align.START)
    row_vk.append(l_vk); row_vk.append(window.art_vk); row_vk.append(window.art_einheit)
    artikel_box.append(row_vk)
    add_art_btn = Gtk.Button(label="Artikel hinzufügen"); add_art_btn.add_css_class('suggested-action')
    add_art_btn.connect('clicked', partial(on_add_artikel_clicked, window))
    artikel_box.append(add_art_btn)
    scrolled_art = Gtk.ScrolledWindow(); scrolled_art.set_vexpand(True); scrolled_art.set_policy(Gtk.PolicyType.NEVER, Gtk.PolicyType.AUTOMATIC)
    window.artikel_list_box = Gtk.ListBox(); window.artikel_list_box.add_css_class('boxed-list')
    scrolled_art.set_child(window.artikel_list_box); artikel_box.append(scrolled_art)
    notebook.append_page(artikel_box, Gtk.Label(label="Artikel"))

    # Kunden Tab
    kunden_box, window.kunden_entries = create_tab_content({
        'name': "Name:", 'strasse': "Straße:", 'plz': "PLZ:", 'ort': "Ort:", 
        'email': "E-Mail:", 'telefon': "Telefon:"
    })
    add_k_btn = Gtk.Button(label="Kunde hinzufügen"); add_k_btn.add_css_class('suggested-action')
    add_k_btn.connect('clicked', partial(on_add_kunde_clicked, window)); kunden_box.append(add_k_btn)
    scrolled_k = Gtk.ScrolledWindow(); scrolled_k.set_vexpand(True); scrolled_k.set_policy(Gtk.PolicyType.NEVER, Gtk.PolicyType.AUTOMATIC)
    window.kunden_list_box = Gtk.ListBox(); window.kunden_list_box.add_css_class('boxed-list')
    scrolled_k.set_child(window.kunden_list_box); kunden_box.append(scrolled_k)
    notebook.append_page(kunden_box, Gtk.Label(label="Kunden"))

    # Lieferanten Tab
    lieferanten_box, window.lieferanten_entries = create_tab_content({
        'name': "Name:", 'strasse': "Straße:", 'plz': "PLZ:", 'ort': "Ort:",
        'email': "E-Mail:", 'telefon': "Telefon:"
    })
    add_l_btn = Gtk.Button(label="Lieferant hinzufügen"); add_l_btn.add_css_class('suggested-action')
    add_l_btn.connect('clicked', partial(on_add_lieferant_clicked, window)); lieferanten_box.append(add_l_btn)
    scrolled_l = Gtk.ScrolledWindow(); scrolled_l.set_vexpand(True); scrolled_l.set_policy(Gtk.PolicyType.NEVER, Gtk.PolicyType.AUTOMATIC)
    window.lieferanten_list_box = Gtk.ListBox(); window.lieferanten_list_box.add_css_class('boxed-list')
    scrolled_l.set_child(window.lieferanten_list_box); lieferanten_box.append(scrolled_l)
    notebook.append_page(lieferanten_box, Gtk.Label(label="Lieferanten"))

    window.content_stack.add_named(page, 'stammdaten')
    populate_firma_fields(window)
    refresh_stammdaten_lists(window)

def populate_firma_fields(window):
    firma = window.app.data['stammdaten']['firma']
    for key, entry in window.firma_entries.items():
        entry.set_text(firma.get(key, ''))

def on_save_firma(window, btn):
    window.app.data['stammdaten']['firma'] = {key: entry.get_text() for key, entry in window.firma_entries.items()}
    window.app.save_data()
    show_message(window, "Erfolg", "Firmendaten gespeichert")

def refresh_stammdaten_lists(window):
    if hasattr(window, 'artikel_list_box'):
        while window.artikel_list_box.get_row_at_index(0): window.artikel_list_box.remove(window.artikel_list_box.get_row_at_index(0))
        for i, a in enumerate(window.app.data['stammdaten']['artikel']):
            row = Gtk.ListBoxRow()
            h = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
            h.set_margin_start(10); h.set_margin_end(10); h.set_margin_top(8); h.set_margin_bottom(8)
            title = Gtk.Label(label=f"{a.get('nr','')} {a.get('name', '')}".strip())
            title.set_halign(Gtk.Align.START); title.set_hexpand(True); h.append(title)
            right = Gtk.Label(label=f"{a.get('vk_preis',0):.2f} €/ {a.get('einheit','Stück')}")
            right.add_css_class('dim-label'); h.append(right)
            btn_edit = Gtk.Button(label="Bearbeiten"); btn_del = Gtk.Button(label="Löschen")
            btn_edit.add_css_class('flat'); btn_del.add_css_class('destructive-action'); btn_del.add_css_class('flat')
            btn_edit.connect('clicked', partial(open_artikel_editor, window, i))
            btn_del.connect('clicked', partial(delete_artikel, window, i))
            h.append(btn_edit); h.append(btn_del)
            row.set_child(h); window.artikel_list_box.append(row)
    if hasattr(window, 'kunden_list_box'):
        while window.kunden_list_box.get_row_at_index(0): window.kunden_list_box.remove(window.kunden_list_box.get_row_at_index(0))
        for i, k in enumerate(window.app.data['stammdaten']['kunden']):
            row = Gtk.ListBoxRow()
            v = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=2)
            v.set_margin_start(10); v.set_margin_end(10); v.set_margin_top(8); v.set_margin_bottom(8)
            top = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
            name = Gtk.Label(label=k.get('name', '')); name.add_css_class('heading'); name.set_halign(Gtk.Align.START); name.set_hexpand(True)
            btn_edit = Gtk.Button(label="Bearbeiten"); btn_del = Gtk.Button(label="Löschen")
            btn_edit.add_css_class('flat'); btn_del.add_css_class('destructive-action'); btn_del.add_css_class('flat')
            btn_edit.connect('clicked', partial(open_kunde_editor, window, i))
            btn_del.connect('clicked', partial(delete_kunde, window, i))
            top.append(name); top.append(btn_edit); top.append(btn_del)
            v.append(top)
            l2 = Gtk.Label(label=f"{k.get('strasse','')} | {k.get('plz','')} {k.get('ort','')}")
            l2.add_css_class('dim-label'); l2.set_halign(Gtk.Align.START); v.append(l2)
            l3 = Gtk.Label(label=f"{k.get('email','')} | {k.get('telefon','')}")
            l3.add_css_class('dim-label'); l3.set_halign(Gtk.Align.START); v.append(l3)
            row.set_child(v); window.kunden_list_box.append(row)
    
    if hasattr(window, 'lieferanten_list_box'):
        while window.lieferanten_list_box.get_row_at_index(0): window.lieferanten_list_box.remove(window.lieferanten_list_box.get_row_at_index(0))
        for i, l in enumerate(window.app.data['stammdaten']['lieferanten']):
            row = Gtk.ListBoxRow()
            v = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=2)
            v.set_margin_start(10); v.set_margin_end(10); v.set_margin_top(8); v.set_margin_bottom(8)
            top = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
            name = Gtk.Label(label=l.get('name', '')); name.add_css_class('heading'); name.set_halign(Gtk.Align.START); name.set_hexpand(True)
            btn_edit = Gtk.Button(label="Bearbeiten"); btn_del = Gtk.Button(label="Löschen")
            btn_edit.add_css_class('flat'); btn_del.add_css_class('destructive-action'); btn_del.add_css_class('flat')
            btn_edit.connect('clicked', partial(open_lieferant_editor, window, i))
            btn_del.connect('clicked', partial(delete_lieferant, window, i))
            top.append(name); top.append(btn_edit); top.append(btn_del)
            v.append(top)
            l2 = Gtk.Label(label=f"{l.get('strasse','')} | {l.get('plz','')} {l.get('ort','')}")
            l2.add_css_class('dim-label'); l2.set_halign(Gtk.Align.START); v.append(l2)
            l3 = Gtk.Label(label=f"{l.get('email','')} | {l.get('telefon','')}")
            l3.add_css_class('dim-label'); l3.set_halign(Gtk.Align.START); v.append(l3)
            row.set_child(v); window.lieferanten_list_box.append(row)

def open_artikel_editor(window, index, _btn=None):
    item = window.app.data['stammdaten']['artikel'][index]
    dlg = Adw.MessageDialog.new(window, "Artikel bearbeiten", "Bearbeiten Sie die Artikel-Daten.")
    dlg.add_response("cancel", "Abbrechen"); dlg.add_response("save", "Speichern")
    dlg.set_response_appearance("save", Adw.ResponseAppearance.SUGGESTED)
    content = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=12)
    content.set_margin_start(16); content.set_margin_end(16); content.set_margin_top(16); content.set_margin_bottom(16)
    def row(lbl, w):
        hb = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
        l = Gtk.Label(label=lbl); l.set_size_request(150, -1); l.set_halign(Gtk.Align.START)
        hb.append(l); hb.append(w); return hb
    e_nr = Gtk.Entry(text=str(item.get('nr', '')))
    e_name = Gtk.Entry(text=str(item.get('name', '')))
    e_vk = Gtk.Entry(text=f"{float(item.get('vk_preis', 0.0)):.2f}")
    dd_einheit = Gtk.DropDown.new_from_strings(EINHEITEN)
    dd_einheit.set_selected(EINHEITEN.index(item.get('einheit', 'Stück')) if item.get('einheit') in EINHEITEN else 0)
    content.append(row("Artikelnummer:", e_nr)); content.append(row("Artikelname:", e_name))
    hb_vk = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
    l_vk = Gtk.Label(label="VK-Preis (€):"); l_vk.set_size_request(150, -1); l_vk.set_halign(Gtk.Align.START)
    hb_vk.append(l_vk); hb_vk.append(e_vk); hb_vk.append(dd_einheit)
    content.append(hb_vk)
    dlg.set_extra_child(content)
    def on_resp(_d, resp):
        if resp == "save":
            name = e_name.get_text().strip()
            if not name: show_message(window, "Fehler", "Artikelname ist erforderlich"); return
            try: vk = float(e_vk.get_text().replace(',', '.'))
            except ValueError: show_message(window, "Fehler", "Gültigen VK-Preis eingeben"); return
            new_item = { 'nr': e_nr.get_text().strip(), 'name': name, 'vk_preis': vk, 'einheit': EINHEITEN[dd_einheit.get_selected()] }
            window.app.data['stammdaten']['artikel'][index] = new_item
            window.app.save_data()
            refresh_stammdaten_lists(window)
            update_master_data_dropdowns(window)
            show_message(window, "Erfolg", "Artikel gespeichert")
        _d.close()
    dlg.connect("response", on_resp)
    dlg.present()

def open_kunde_editor(window, index, _btn=None):
    item = window.app.data['stammdaten']['kunden'][index]
    dlg = Adw.MessageDialog.new(window, "Kunde bearbeiten", "Bearbeiten Sie die Kunden-Daten.")
    dlg.add_response("cancel", "Abbrechen"); dlg.add_response("save", "Speichern")
    dlg.set_response_appearance("save", Adw.ResponseAppearance.SUGGESTED)
    content = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=12)
    content.set_margin_start(16); content.set_margin_end(16); content.set_margin_top(16); content.set_margin_bottom(16)
    
    entries = {}
    for key, label in {'name': "Name:", 'strasse': "Straße:", 'plz': "PLZ:", 'ort': "Ort:", 'email': "E-Mail:", 'telefon': "Telefon:"}.items():
        row = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
        l = Gtk.Label(label=label); l.set_size_request(150, -1); l.set_halign(Gtk.Align.START)
        entry = Gtk.Entry(text=str(item.get(key, '')))
        entries[key] = entry
        row.append(l); row.append(entry)
        content.append(row)

    dlg.set_extra_child(content)
    def on_resp(_d, resp):
        if resp == "save":
            name = entries['name'].get_text().strip()
            if not name: show_message(window, "Fehler", "Kundenname ist erforderlich"); return
            new_item = {key: entry.get_text() for key, entry in entries.items()}
            window.app.data['stammdaten']['kunden'][index] = new_item
            window.app.save_data()
            refresh_stammdaten_lists(window)
            update_master_data_dropdowns(window)
            show_message(window, "Erfolg", "Kunde gespeichert")
        _d.close()
    dlg.connect("response", on_resp)
    dlg.present()

def open_lieferant_editor(window, index, _btn=None):
    item = window.app.data['stammdaten']['lieferanten'][index]
    dlg = Adw.MessageDialog.new(window, "Lieferant bearbeiten", "Bearbeiten Sie die Lieferanten-Daten.")
    dlg.add_response("cancel", "Abbrechen"); dlg.add_response("save", "Speichern")
    dlg.set_response_appearance("save", Adw.ResponseAppearance.SUGGESTED)
    content = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=12)
    content.set_margin_start(16); content.set_margin_end(16); content.set_margin_top(16); content.set_margin_bottom(16)
    
    entries = {}
    for key, label in {'name': "Name:", 'strasse': "Straße:", 'plz': "PLZ:", 'ort': "Ort:", 'email': "E-Mail:", 'telefon': "Telefon:"}.items():
        row = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
        l = Gtk.Label(label=label); l.set_size_request(150, -1); l.set_halign(Gtk.Align.START)
        entry = Gtk.Entry(text=str(item.get(key, '')))
        entries[key] = entry
        row.append(l); row.append(entry)
        content.append(row)

    dlg.set_extra_child(content)
    def on_resp(_d, resp):
        if resp == "save":
            name = entries['name'].get_text().strip()
            if not name: show_message(window, "Fehler", "Lieferantenname ist erforderlich"); return
            new_item = {key: entry.get_text() for key, entry in entries.items()}
            window.app.data['stammdaten']['lieferanten'][index] = new_item
            window.app.save_data()
            refresh_stammdaten_lists(window)
            update_master_data_dropdowns(window)
            show_message(window, "Erfolg", "Lieferant gespeichert")
        _d.close()
    dlg.connect("response", on_resp)
    dlg.present()

def delete_artikel(window, index, _btn=None):
    name = window.app.data['stammdaten']['artikel'][index].get('name', '')
    if confirm(window, "Löschen bestätigen", f"Artikel „{name}“ wirklich löschen?"):
        del window.app.data['stammdaten']['artikel'][index]
        window.app.save_data()
        refresh_stammdaten_lists(window); update_master_data_dropdowns(window)
        show_message(window, "Erfolg", "Artikel gelöscht")

def delete_kunde(window, index, _btn=None):
    name = window.app.data['stammdaten']['kunden'][index].get('name', '')
    if confirm(window, "Löschen bestätigen", f"Kunde „{name}“ wirklich löschen?"):
        del window.app.data['stammdaten']['kunden'][index]
        window.app.save_data()
        refresh_stammdaten_lists(window); update_master_data_dropdowns(window)
        show_message(window, "Erfolg", "Kunde gelöscht")

def delete_lieferant(window, index, _btn=None):
    name = window.app.data['stammdaten']['lieferanten'][index].get('name', '')
    if confirm(window, "Löschen bestätigen", f"Lieferant „{name}“ wirklich löschen?"):
        del window.app.data['stammdaten']['lieferanten'][index]
        window.app.save_data()
        refresh_stammdaten_lists(window); update_master_data_dropdowns(window)
        show_message(window, "Erfolg", "Lieferant gelöscht")

def on_add_artikel_clicked(window, _btn):
    name = window.art_name.get_text().strip()
    if not name: show_message(window, "Fehler", "Artikelname ist erforderlich"); return
    try: vk = float(window.art_vk.get_text().replace(',', '.'))
    except ValueError: show_message(window, "Fehler", "Gültigen VK-Preis eingeben"); return
    item = { 'nr': window.art_nr.get_text().strip(), 'name': name, 'vk_preis': vk, 'einheit': EINHEITEN[window.art_einheit.get_selected()] }
    window.app.data['stammdaten']['artikel'].append(item)
    window.app.save_data()
    refresh_stammdaten_lists(window); update_master_data_dropdowns(window); show_message(window, "Erfolg", "Artikel gespeichert")
    window.art_nr.set_text(""); window.art_name.set_text(""); window.art_vk.set_text("0.00"); window.art_einheit.set_selected(0)

def on_add_kunde_clicked(window, _btn):
    name = window.kunden_entries['name'].get_text().strip()
    if not name: show_message(window, "Fehler", "Kundenname ist erforderlich"); return
    item = {key: entry.get_text() for key, entry in window.kunden_entries.items()}
    window.app.data['stammdaten']['kunden'].append(item)
    window.app.save_data()
    refresh_stammdaten_lists(window); update_master_data_dropdowns(window); show_message(window, "Erfolg", "Kunde gespeichert")
    for entry in window.kunden_entries.values(): entry.set_text("")
    
def on_add_lieferant_clicked(window, _btn):
    name = window.lieferanten_entries['name'].get_text().strip()
    if not name: show_message(window, "Fehler", "Lieferantenname ist erforderlich"); return
    item = {key: entry.get_text() for key, entry in window.lieferanten_entries.items()}
    window.app.data['stammdaten']['lieferanten'].append(item)
    window.app.save_data()
    refresh_stammdaten_lists(window); update_master_data_dropdowns(window); show_message(window, "Erfolg", "Lieferant gespeichert")
    for entry in window.lieferanten_entries.values(): entry.set_text("")

def update_master_data_dropdowns(window):
    artikel_namen = [a['name'] for a in window.app.data['stammdaten']['artikel']]
    window.einkauf_artikel_dd.set_model(Gtk.StringList.new(artikel_namen))
    window.verkauf_artikel_dd.set_model(Gtk.StringList.new(artikel_namen))
    
    lieferanten_namen = [l['name'] for l in window.app.data['stammdaten']['lieferanten']]
    window.einkauf_lieferant_dd.set_model(Gtk.StringList.new(lieferanten_namen))

    kunden_namen = [k['name'] for k in window.app.data['stammdaten']['kunden']]
    window.verkauf_kunde_dd.set_model(Gtk.StringList.new(kunden_namen))