# Kassenbuch.spec (final, corrected version for modern PyInstaller)

# Dieser Block wird am Anfang der Datei ausgeführt
import os

# --- KORREKTE, MODERNE METHODE ZUM SAMMELN VON GI-DATEN ---
# Wir importieren die notwendigen Funktionen direkt von PyInstaller.hooks.
from PyInstaller.utils.hooks import collect_data_files

# Basiskonfiguration
a = Analysis(
    ['main.py'],
    pathex=[],
    binaries=[],
    # Hier fügen wir unsere Daten hinzu.
    datas=[
        ('icons', 'icons'),
    ],
    # PyInstaller muss wissen, welche Module es explizit einbinden soll
    hiddenimports=[
        'gi.repository.Gtk',
        'gi.repository.Adw',
        'gi.repository.Gio',
        'gi.repository.Gdk',
        'gi.repository.GLib'
    ],
    hookspath=[],
    hooksconfig={},
    runtime_hooks=[],
    excludes=[],
    win_no_prefer_redirects=False,
    win_private_assemblies=False,
    cipher=None,
    noarchive=False,
)

# --- FÜGE DIE GI-DATEN NACH DER ANALYSE HINZU ---
# Dies ist der moderne Ersatz für get_gi_typelibs.
# Es sammelt alle notwendigen XML- und Typelib-Dateien.
a.datas += collect_data_files('gi')
a.datas += collect_data_files('adwaita') # Sicherheitshalber auch Adwaita hinzufügen


# Hier definieren wir, was im finalen Bundle landet
pyz = PYZ(a.pure, a.zipped_data, cipher=None)

exe = EXE(
    pyz,
    a.scripts,
    [],
    exclude_binaries=True,
    name='Kassenbuch',
    debug=False,
    bootloader_ignore_signals=False,
    strip=False,
    upx=True,
    console=False,
    disable_windowed_traceback=False,
    argv_emulation=False,
    target_arch=None,
    codesign_identity=None,
    entitlements_file=None,
    icon='icons/kassenbuch.png',
)

# Der 'COLLECT'-Schritt fasst alles zusammen
coll = COLLECT(
    exe,
    a.binaries,
    a.zipfiles,
    a.datas,
    strip=False,
    upx=True,
    upx_exclude=[],
    name='Kassenbuch',
)
