#!/bin/bash

# Dieses Skript baut das Kassenbuch AppImage mit dem Standard-Werkzeug 'linuxdeploy'.
# Es muss aus dem Haupt-Projektverzeichnis ausgeführt werden.

# Beendet das Skript sofort, wenn ein Befehl fehlschlägt
set -e

# --- Konfiguration ---
APP_NAME="Kassenbuch"
APP_DIR="$APP_NAME.AppDir"
LINUXDEPLOY_BIN="linuxdeploy-x86_64.AppImage"
PYTHON_PLUGIN_BIN="linuxdeploy-plugin-python.AppImage" # Korrekter Name ohne Version/Arch

# --- Schritt 1: Lade die korrekten Werkzeuge herunter ---
echo ">>> Prüfe und lade Build-Werkzeuge..."

if [ ! -f "$LINUXDEPLOY_BIN" ]; then
    echo "Lade linuxdeploy herunter..."
    wget "https://github.com/linuxdeploy/linuxdeploy/releases/download/continuous/linuxdeploy-x86_64.AppImage" -O "$LINUXDEPLOY_BIN"
    chmod +x "$LINUXDEPLOY_BIN"
fi

# DIES IST DER KORREKTE, FUNKTIONIERENDE LINK FÜR DAS PYTHON-PLUGIN
if [ ! -f "$PYTHON_PLUGIN_BIN" ]; then
    echo "Lade linuxdeploy-plugin-python herunter..."
    wget "https://github.com/linuxdeploy/linuxdeploy-plugin-python/releases/download/continuous/linuxdeploy-plugin-python.AppImage" -O "$PYTHON_PLUGIN_BIN"
    chmod +x "$PYTHON_PLUGIN_BIN"
fi


# --- Schritt 2: Aufräumen und Vorbereiten ---
echo ">>> Räume alte Builds auf und bereite das Build-Verzeichnis vor..."
rm -rf "$APP_DIR"
mkdir -p "$APP_DIR/usr/bin"
mkdir -p "$APP_DIR/usr/share/icons/hicolor/256x256/apps"

# --- Schritt 3: Anwendungsdateien kopieren ---
echo ">>> Kopiere Anwendungsdateien..."
# Wir kopieren die App in eine saubere Struktur
cp -r *.py icons/ "$APP_DIR/usr/bin/"

# Kopiere den Starter und das Icon an die richtigen Stellen
cp kassenbuch.desktop "$APP_DIR/"
cp icons/kassenbuch.png "$APP_DIR/usr/share/icons/hicolor/256x256/apps/kassenbuch.png"
# Erstelle einen Link zum Icon an der Stelle, an der linuxdeploy es erwartet
ln -s "usr/share/icons/hicolor/256x256/apps/kassenbuch.png" "$APP_DIR/kassenbuch.png"

# --- Schritt 4: Python und Abhängigkeiten bündeln ---
echo ">>> Bündle Python und Pip-Pakete..."

# Umgebungsvariablen für das Python-Plugin setzen
export PIP_REQUIREMENTS_FILE="requirements.txt"
export PYTHON_VERSION=3.11

# Führe linuxdeploy mit dem Python-Plugin aus
# Es bündelt Python, Pip-Pakete und alle benötigten Systembibliotheken (GTK, etc.)
./"$LINUXDEPLOY_BIN" \
    --appdir "$APP_DIR" \
    --plugin python \
    --output appimage \
    --desktop-file kassenbuch.desktop

echo ""
echo ">>> AppImage-Erstellung erfolgreich! <<<"
echo "Du findest die Datei '$APP_NAME-*.AppImage' im aktuellen Verzeichnis."