from utils import Gtk, Adw

def create_bestand_page(window):
    page = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=20)
    page.set_margin_start(40); page.set_margin_end(40)
    page.set_margin_top(40); page.set_margin_bottom(40)
    header = Gtk.Label(label="Bestandsliste"); header.add_css_class('title-2'); header.set_halign(Gtk.Align.START); page.append(header)
    scrolled = Gtk.ScrolledWindow(); scrolled.set_vexpand(True); scrolled.set_policy(Gtk.PolicyType.NEVER, Gtk.PolicyType.AUTOMATIC)
    window.bestand_list_box = Gtk.ListBox(); window.bestand_list_box.add_css_class('boxed-list')
    scrolled.set_child(window.bestand_list_box); page.append(scrolled)
    window.content_stack.add_named(page, 'bestand')

def refresh_bestand_list(window):
    if not hasattr(window, 'bestand_list_box'): return
    while True:
        row = window.bestand_list_box.get_row_at_index(0)
        if row is None: break
        window.bestand_list_box.remove(row)

    for item in window.app.data['bestand']:
        if item.get('menge', 0) <= 0: continue
        row = Gtk.ListBoxRow()
        box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL)
        box.set_margin_start(10); box.set_margin_end(10); box.set_margin_top(10); box.set_margin_bottom(10)
        artikel = Gtk.Label(label=item['artikel']); artikel.set_halign(Gtk.Align.START); artikel.set_hexpand(True); box.append(artikel)
        menge = Gtk.Label(label=f"{item.get('menge', 0)} {item.get('einheit','')}"); menge.add_css_class('dim-label'); box.append(menge)
        row.set_child(box); window.bestand_list_box.append(row)