from utils import Path, json, show_message, Adw
from gi.repository import Gtk, Gdk
from db import connect, init_db, read_all, write_all


class KassenbuchApp(Adw.Application):
    def __init__(self):
        super().__init__(application_id="com.kassenbuch.app")

        base = Path(__file__).resolve().parent
        self.data_file = base / "kassenbuch_data.json"   # für einmalige Migration
        self.db_path = base / "kassenbuch.db"            # neue SQLite-Datei
        self.conn = connect(self.db_path)
        init_db(self.conn)
        self.data = self.load_data()

        # --- App-Icon registrieren ---
        icon_theme = Gtk.IconTheme.get_for_display(Gdk.Display.get_default())
        icon_path = base / "icons"
        if icon_path.is_dir():
            icon_theme.add_search_path(str(icon_path))

    def do_activate(self):
        from window import KassenbuchWindow
        win = KassenbuchWindow(application=self)
        win.present()

    def load_data(self):
        """Liest Daten aus SQLite. Migriert optional einmalig von JSON → SQLite."""
        # Prüfen, ob Datenbank leer ist
        try:
            cur = self.conn.cursor()
            count = cur.execute("SELECT COUNT(*) FROM einkaeufe").fetchone()[0]
        except Exception:
            count = 0

        # Migration von JSON falls DB leer + JSON vorhanden
        if count == 0 and self.data_file.exists():
            try:
                with open(self.data_file, "r", encoding="utf-8") as f:
                    legacy = json.load(f)
                # Standardfelder absichern
                legacy.setdefault("stammdaten", {})
                legacy["stammdaten"].setdefault("firma", {
                    "name": "", "strasse": "", "plz": "", "ort": "",
                    "email": "", "telefon": "", "bank": "", "iban": "", "bic": ""
                })
                legacy["stammdaten"].setdefault("artikel", [])
                legacy["stammdaten"].setdefault("kunden", [])
                legacy["stammdaten"].setdefault("lieferanten", [])
                legacy.setdefault("einkäufe", [])
                legacy.setdefault("verkäufe", [])
                legacy.setdefault("bestand", [])
                legacy.setdefault("anfangsbestand", 0.0)
                legacy.setdefault("privatentnahmen", [])
                legacy.setdefault("sperrliste", [])
                write_all(self.conn, legacy)
                print("Migration von JSON nach SQLite abgeschlossen.")
            except Exception as e:
                print(f"Migration fehlgeschlagen: {e}")

        # Aktuelle Daten aus DB laden
        return read_all(self.conn)

    def save_data(self):
        """Schreibt aktuelle Daten ins SQLite-Backend."""
        write_all(self.conn, self.data)