#!/bin/bash

echo ">>> Kassenbuch Installations-Skript für Debian/Ubuntu <<<"

# Schritt 1: System-Abhängigkeiten und verfügbare Python-Pakete installieren
echo "--> Installiere Abhängigkeiten via APT (sudo-Passwort wird benötigt)..."
sudo apt update
sudo apt install -y python3 python3-pip python3-gi python3-gi-cairo gir1.2-gtk-4.0 gir1.2-adw-1 python3-reportlab python3-lxml

# Schritt 2: Das fehlende Python-Paket mit der --break-system-packages Ausnahme installieren
echo "--> Installiere 'factur-x' für den aktuellen Benutzer via pip..."
pip install --user --break-system-packages factur-x

# Schritt 3: Start-Skript ausführbar machen
echo "--> Mache Start-Skript ausführbar..."
chmod +x start.sh

# Schritt 4: .desktop-Datei erstellen und installieren
echo "--> Erstelle und installiere Anwendungs-Starter..."
APP_DIR=$(pwd)
DESKTOP_FILE=~/.local/share/applications/kassenbuch.desktop

# Erstellt die .desktop Datei mit den korrekten Pfaden
cat << EOF > "$DESKTOP_FILE"
[Desktop Entry]
Version=1.0
Type=Application
Name=Kassenbuch
Comment=Einfaches Kassenbuch Programm
Exec=$APP_DIR/start.sh
Icon=$APP_DIR/icons/app_icon.png
Terminal=false
Categories=Office;Finance;
EOF

echo ""
echo ">>> Installation abgeschlossen! <<<"
echo "Du solltest 'Kassenbuch' jetzt in deinem Anwendungsmenü finden."
echo "(Eventuell musst du dich ab- und wieder anmelden, damit es erscheint.)"