import gi
gi.require_version('Gtk', '4.0')
gi.require_version('Adw', '1')
from gi.repository import Gtk, Adw, Gio, GLib
import json
from datetime import datetime
from pathlib import Path
from functools import partial
import os

# Versuchen, die ReportLab-Bibliothek zu importieren.
try:
    from reportlab.platypus import SimpleDocTemplate, Paragraph, Spacer, Table, TableStyle, Image, PageBreak
    from reportlab.lib.styles import getSampleStyleSheet, ParagraphStyle
    from reportlab.lib.pagesizes import A4
    from reportlab.lib.units import cm
    from reportlab.lib import colors
    from reportlab.pdfgen import canvas
    REPORTLAB_AVAILABLE = True
except ImportError:
    REPORTLAB_AVAILABLE = False

EINHEITEN = ["Stück", "kg", "g", "L"]

def show_message(window, title, message):
    dialog = Adw.MessageDialog.new(window, title, message)
    dialog.add_response("ok", "OK")
    dialog.set_response_appearance("ok", Adw.ResponseAppearance.SUGGESTED)
    dialog.connect('response', lambda d, r: d.close())
    dialog.present()

def confirm(window, title, text):
    dlg = Adw.MessageDialog.new(window, title, text)
    dlg.add_response("cancel", "Abbrechen")
    dlg.add_response("ok", "OK")
    dlg.set_response_appearance("ok", Adw.ResponseAppearance.SUGGESTED)
    dlg.set_default_response("cancel")
    result = {'ok': False}
    def on_resp(_d, resp):
        result['ok'] = (resp == "ok")
        _d.close()
    dlg.connect("response", on_resp)
    dlg.present()
    while dlg.is_visible(): GLib.MainContext.default().iteration(True)
    return result['ok']