# app.py (final, corrected version)
from utils import Path, json, show_message, Adw
from gi.repository import Gtk, Gdk

class KassenbuchApp(Adw.Application):
    def __init__(self):
        super().__init__(application_id='com.kassenbuch.app')
        self.data_file = Path(__file__).resolve().parent / 'kassenbuch_data.json'
        self.data = self.load_data()

        # --- KORREKTER WEG ZUM REGISTRIEREN DES ICONS ---
        # Wir sagen der App, dass sie im 'icons'-Ordner nach Icons suchen soll.
        # Das macht 'app_icon.png' unter dem Namen 'app_icon' verfügbar.
        icon_theme = Gtk.IconTheme.get_for_display(Gdk.Display.get_default())
        icon_path = Path(__file__).resolve().parent / 'icons'
        if icon_path.is_dir():
            icon_theme.add_search_path(str(icon_path))

    def do_activate(self):
        from window import KassenbuchWindow
        # Das Setzen des Icons passiert jetzt im Fenster selbst, da das Theme bekannt ist.
        win = KassenbuchWindow(application=self)
        win.present()

    def load_data(self):
        if self.data_file.exists():
            try:
                with open(self.data_file, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    data.setdefault('stammdaten', {})
                    data['stammdaten'].setdefault('firma', {
                        'name': '', 'strasse': '', 'plz': '', 'ort': '',
                        'email': '', 'telefon': '',
                        'bank': '', 'iban': '', 'bic': ''
                    })
                    data['stammdaten'].setdefault('artikel', [])
                    data['stammdaten'].setdefault('kunden', [])
                    data['stammdaten'].setdefault('lieferanten', [])
                    data.setdefault('einkäufe', [])
                    data.setdefault('verkäufe', [])
                    data.setdefault('bestand', [])
                    data.setdefault('anfangsbestand', 0.0)
                    data.setdefault('privatentnahmen', [])
                    return data
            except Exception:
                pass
        return {
            'einkäufe': [], 'verkäufe': [], 'bestand': [], 'anfangsbestand': 0.0,
            'privatentnahmen': [], 'stammdaten': {
                'firma': {'name': '', 'strasse': '', 'plz': '', 'ort': '', 'email': '', 'telefon': '',
                          'bank': '', 'iban': '', 'bic': ''},
                'artikel': [], 'kunden': [], 'lieferanten': []
            }
        }

    def save_data(self):
        with open(self.data_file, 'w', encoding='utf-8') as f:
            json.dump(self.data, f, ensure_ascii=False, indent=2)