# window.py (final, corrected and simplified version)
from pathlib import Path
from utils import Gtk, Adw, EINHEITEN, show_message, confirm
from gi.repository import Gio
from einkauf import create_einkauf_page, create_einkauf_list_page, refresh_einkauf_list, update_einkauf_jahr_filter
from verkauf import create_verkauf_page, create_verkauf_list_page, refresh_verkauf_list
from bestand import create_bestand_page, refresh_bestand_list
from kassenbuch import create_kassenbuch_page, refresh_kassenbuch
from stammdaten import create_stammdaten_page, refresh_stammdaten_lists, update_master_data_dropdowns
from rechnung import create_rechnung_page

class KassenbuchWindow(Adw.ApplicationWindow):
    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        
        # --- NEU: Icon für Taskleiste/Dock setzen (jetzt einfach per Name) ---
        self.set_icon_name("app_icon") # Name der Datei ohne .png

        self.set_default_size(1200, 760)
        self.set_resizable(True)
        self.app = self.get_application()
        self._is_updating_prices = False

        self.toolbar_view = Adw.ToolbarView()
        header = Adw.HeaderBar()
        header.set_hexpand(True)
        header.set_show_start_title_buttons(False)
        header.set_show_end_title_buttons(True)

        # --- NEU: Icon in der Titelleiste (jetzt auch einfach per Name) ---
        euro_icon = Gtk.Image.new_from_icon_name("app_icon")
        euro_icon.set_pixel_size(24)
        euro_icon.set_valign(Gtk.Align.CENTER)
        euro_icon.set_margin_start(6)
        header.pack_start(euro_icon)

        title = Adw.WindowTitle(title="Kassenbuch", subtitle="")
        header.set_title_widget(title)

        menu_button = Gtk.MenuButton()
        menu_button.set_icon_name("open-menu-symbolic")
        menu_model = Gio.Menu()
        menu_model.append("Über Kassenbuch", "app.about")
        menu_button.set_menu_model(menu_model)
        header.pack_end(menu_button)
        about_action = Gio.SimpleAction.new("about", None)
        about_action.connect("activate", self.on_about_clicked)
        self.get_application().add_action(about_action)

        self.toolbar_view.add_top_bar(header)
        
        self.main_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL)
        self.toolbar_view.set_content(self.main_box)
        self.set_content(self.toolbar_view)

        self.create_sidebar()

        self.content_stack = Gtk.Stack()
        self.content_stack.set_transition_type(Gtk.StackTransitionType.SLIDE_LEFT_RIGHT)
        self.main_box.append(self.content_stack)

        create_einkauf_page(self)
        create_einkauf_list_page(self)
        create_bestand_page(self)
        create_verkauf_page(self)
        create_verkauf_list_page(self)
        create_kassenbuch_page(self)
        create_stammdaten_page(self)
        create_rechnung_page(self)

        update_master_data_dropdowns(self)

        refresh_einkauf_list(self)
        refresh_bestand_list(self)
        refresh_verkauf_list(self)
        refresh_kassenbuch(self)
        refresh_stammdaten_lists(self)
        self.content_stack.set_visible_child_name('kassenbuch')

    def create_sidebar(self):
        #... (diese Funktion bleibt unverändert)
        sidebar = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=0)
        sidebar.set_size_request(260, -1)
        sidebar.add_css_class('sidebar')
        header = Gtk.Label(label="Kassenbuch")
        header.add_css_class('title-1')
        header.set_margin_top(20)
        header.set_margin_bottom(20)
        sidebar.append(header)
        list_box = Gtk.ListBox()
        list_box.set_selection_mode(Gtk.SelectionMode.SINGLE)
        list_box.add_css_class('navigation-sidebar')
        pages = [
            ('Einkauf erfassen', 'einkauf'), ('Einkäufe anzeigen', 'einkauf_list'),
            ('Bestandsliste', 'bestand'), ('Verkauf erfassen', 'verkauf'),
            ('Verkäufe anzeigen', 'verkauf_list'), ('Kassenbuch', 'kassenbuch'),
            ('Rechnung erstellen', 'rechnung'),
            ('Stammdaten', 'stammdaten'),
        ]
        for label, page_name in pages:
            row = Gtk.ListBoxRow()
            box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
            box.set_margin_start(10); box.set_margin_end(10)
            box.set_margin_top(8); box.set_margin_bottom(8)
            label_widget = Gtk.Label(label=label)
            label_widget.set_halign(Gtk.Align.START)
            box.append(label_widget)
            row.set_child(box)
            row.page_name = page_name
            list_box.append(row)
        list_box.connect('row-activated', self.on_sidebar_row_activated)
        sidebar.append(list_box)
        self.main_box.append(sidebar)
        list_box.select_row(list_box.get_row_at_index(5))

    def on_sidebar_row_activated(self, list_box, row):
        self.content_stack.set_visible_child_name(row.page_name)

    def confirm(self, title, text):
        return confirm(self, title, text)

    def show_message(self, title, message):
        show_message(self, title, message)

    def on_about_clicked(self, action, param):
        """ Zeigt das Info-Fenster an """
        dialog = Adw.AboutWindow(transient_for=self)
        dialog.set_application_name("Kassenbuch")
        
        # --- NEU: Setzt das Icon im Info-Dialog (jetzt auch einfach per Name) ---
        dialog.set_application_icon("app_icon")
        
        dialog.set_version("1.0")
        dialog.set_developer_name("designed by armin@pinguin-tv")
        dialog.set_website("https://www.pinguin-tv.de")
        
        dialog.add_link("Spenden via PayPal", "https://www.paypal.com/paypalme/pinguintv")
        
        dialog.set_license_type(Gtk.License.GPL_3_0_ONLY)
        dialog.set_copyright("© 2025 Armin")

        dialog.present()