# window.py (updated)
from pathlib import Path  # <-- HIER IST DIE WICHTIGE NEUE ZEILE
from utils import Gtk, Adw, EINHEITEN, show_message, confirm
from einkauf import create_einkauf_page, create_einkauf_list_page, refresh_einkauf_list, update_einkauf_jahr_filter
from verkauf import create_verkauf_page, create_verkauf_list_page, refresh_verkauf_list
from bestand import create_bestand_page, refresh_bestand_list
from kassenbuch import create_kassenbuch_page, refresh_kassenbuch
from stammdaten import create_stammdaten_page, refresh_stammdaten_lists, update_master_data_dropdowns
from rechnung import create_rechnung_page

class KassenbuchWindow(Adw.ApplicationWindow):
    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.set_default_size(1200, 760)
        self.set_resizable(True)
        self.app = self.get_application()
        self._is_updating_prices = False

        self.toolbar_view = Adw.ToolbarView()
        header = Adw.HeaderBar()
        header.set_hexpand(True)
        header.set_show_start_title_buttons(False)
        header.set_show_end_title_buttons(True)

        # --- KORRIGIERTER BLOCK ZUM LADEN DES ICONS ---
        # Lade das Icon aus der Datei für die Titelleiste
        try:
            icon_path = Path(__file__).resolve().parent / 'icons' / 'app_icon.png'
            if icon_path.exists():
                euro_icon = Gtk.Image.new_from_file(str(icon_path))
                euro_icon.set_pixel_size(24) # Setze eine passende Größe
            else:
                # Fallback, falls die Datei nicht existiert
                euro_icon = Gtk.Image.new_from_icon_name("emblem-money")
                euro_icon.set_pixel_size(24)
        except Exception as e:
            print(f"Konnte Icon für Titelleiste nicht laden: {e}")
            # Fallback bei einem Fehler
            euro_icon = Gtk.Image.new_from_icon_name("emblem-money")
            euro_icon.set_pixel_size(24)

        euro_icon.set_valign(Gtk.Align.CENTER)
        euro_icon.set_margin_start(6)
        header.pack_start(euro_icon)
        # --- ENDE DES KORRIGIERTEN BLOCKS ---

        title = Adw.WindowTitle(title="Kassenbuch", subtitle="")
        header.set_title_widget(title)
        self.toolbar_view.add_top_bar(header)

        self.main_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL)
        self.toolbar_view.set_content(self.main_box)
        self.set_content(self.toolbar_view)

        self.create_sidebar()

        self.content_stack = Gtk.Stack()
        self.content_stack.set_transition_type(Gtk.StackTransitionType.SLIDE_LEFT_RIGHT)
        self.main_box.append(self.content_stack)

        create_einkauf_page(self)
        create_einkauf_list_page(self)
        create_bestand_page(self)
        create_verkauf_page(self)
        create_verkauf_list_page(self)
        create_kassenbuch_page(self)
        create_stammdaten_page(self)
        create_rechnung_page(self)

        update_master_data_dropdowns(self)

        refresh_einkauf_list(self)
        refresh_bestand_list(self)
        refresh_verkauf_list(self)
        refresh_kassenbuch(self)
        refresh_stammdaten_lists(self)
        self.content_stack.set_visible_child_name('kassenbuch')

    def create_sidebar(self):
        sidebar = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=0)
        sidebar.set_size_request(260, -1)
        sidebar.add_css_class('sidebar')
        header = Gtk.Label(label="Kassenbuch")
        header.add_css_class('title-1')
        header.set_margin_top(20)
        header.set_margin_bottom(20)
        sidebar.append(header)
        list_box = Gtk.ListBox()
        list_box.set_selection_mode(Gtk.SelectionMode.SINGLE)
        list_box.add_css_class('navigation-sidebar')
        pages = [
            ('Einkauf erfassen', 'einkauf'), ('Einkäufe anzeigen', 'einkauf_list'),
            ('Bestandsliste', 'bestand'), ('Verkauf erfassen', 'verkauf'),
            ('Verkäufe anzeigen', 'verkauf_list'), ('Kassenbuch', 'kassenbuch'),
            ('Rechnung erstellen', 'rechnung'),
            ('Stammdaten', 'stammdaten'),
        ]
        for label, page_name in pages:
            row = Gtk.ListBoxRow()
            box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
            box.set_margin_start(10); box.set_margin_end(10)
            box.set_margin_top(8); box.set_margin_bottom(8)
            label_widget = Gtk.Label(label=label)
            label_widget.set_halign(Gtk.Align.START)
            box.append(label_widget)
            row.set_child(box)
            row.page_name = page_name
            list_box.append(row)
        list_box.connect('row-activated', self.on_sidebar_row_activated)
        sidebar.append(list_box)
        self.main_box.append(sidebar)
        list_box.select_row(list_box.get_row_at_index(0))

    def on_sidebar_row_activated(self, list_box, row):
        self.content_stack.set_visible_child_name(row.page_name)

    def confirm(self, title, text):
        return confirm(self, title, text)

    def show_message(self, title, message):
        show_message(self, title, message)