from utils import Path, json, show_message, Adw

class KassenbuchApp(Adw.Application):
    def __init__(self):
        super().__init__(application_id='com.kassenbuch.app')
        self.data_file = Path(__file__).resolve().parent / 'kassenbuch_data.json'
        self.data = self.load_data()

    def do_activate(self):
        from window import KassenbuchWindow
        # NEU: Importiere die benötigten Bibliotheken
        from gi.repository import Gdk
        from utils import Path

        win = KassenbuchWindow(application=self)
        
        # NEU: Versuche, das eigene Icon aus der Datei zu laden
        icon_path = Path(__file__).resolve().parent / 'icons' / 'app_icon.png'
        if icon_path.exists():
            try:
                # Gdk.Texture ist der moderne Weg in GTK4, ein Bild zu laden
                texture = Gdk.Texture.new_from_filename(str(icon_path))
                win.set_icon(texture)
            except Exception:
                 # Fallback, falls das Bild nicht geladen werden kann
                win.set_icon_name('emblem-money')
        else:
            # Fallback, falls die Datei nicht existiert
            win.set_icon_name('emblem-money')
        
        win.present()

    def load_data(self):
        if self.data_file.exists():
            try:
                with open(self.data_file, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    data.setdefault('stammdaten', {})
                    data['stammdaten'].setdefault('firma', {
                        'name': '', 'strasse': '', 'plz': '', 'ort': '',
                        'email': '', 'telefon': '',
                        'bank': '', 'iban': '', 'bic': ''
                    })
                    data['stammdaten'].setdefault('artikel', [])
                    data['stammdaten'].setdefault('kunden', [])
                    data['stammdaten'].setdefault('lieferanten', [])
                    data.setdefault('einkäufe', [])
                    data.setdefault('verkäufe', [])
                    data.setdefault('bestand', [])
                    data.setdefault('anfangsbestand', 0.0)
                    data.setdefault('privatentnahmen', [])
                    return data
            except Exception:
                pass
        return {
            'einkäufe': [], 'verkäufe': [], 'bestand': [], 'anfangsbestand': 0.0,
            'privatentnahmen': [], 'stammdaten': {
                'firma': {'name': '', 'strasse': '', 'plz': '', 'ort': '', 'email': '', 'telefon': '',
                          'bank': '', 'iban': '', 'bic': ''},
                'artikel': [], 'kunden': [], 'lieferanten': []
            }
        }

    def save_data(self):
        with open(self.data_file, 'w', encoding='utf-8') as f:
            json.dump(self.data, f, ensure_ascii=False, indent=2)