# src/translations.py

CURRENT_LANG = "en"

STRINGS = {
    "de": {
        "btn_next": "Weiter",
        "btn_back": "Zurück",
        "btn_install": "Installieren",
        "btn_reboot": "Neustarten",
        "btn_quit": "Beenden",
        
        "step_welcome": "Willkommen",
        "step_system": "System",
        "step_user": "Benutzer",
        "step_part": "Festplatte",
        "step_summary": "Übersicht",
        "step_install": "Installation",
        "step_done": "Fertig",
        
        "wel_title": "Void Linux Installer",
        "wel_desc": "Dieser Assistent installiert das aktuelle Live-System auf deinen Computer.\nDas System wird kopiert und anschließend angepasst.",
        
        # NEU / ANGEPASST
        "sys_title": "Systemkonfiguration",
        "sys_desc": "Wähle deine Systemeinstellungen für Sprache, Zeitzone und Tastatur-Layout.",
        "sys_region": "Region & Sprache",
        "sys_lang": "Systemsprache:",
        "sys_tz": "Zeitzone:",
        "sys_kbd_frame": "Tastatur",
        "sys_layout": "Layout:",
        
        "part_title": "Partitionierungsmethode",
        "part_disk": "Zielfestplatte:",
        "part_erase": "Festplatte löschen",
        "part_erase_desc": "Löscht alle Daten und nutzt die gesamte Festplatte.",
        "part_free": "In freien Speicher installieren",
        "part_free_desc": "Nutzt unpartitionierten Bereich (Dual Boot).",
        "part_fs": "Dateisystem:",
        "part_swap": "Swap Partition (8 GB)",
        "part_home": "Separate /home Partition",
        "part_warn": "ACHTUNG: Daten gehen verloren!",
        
        "sum_title": "Zusammenfassung",
        "sum_dev": "Zielfestplatte",
        "sum_mode": "Modus",
        "sum_fs": "Dateisystem",
        "sum_user": "Benutzer",
        "sum_host": "Hostname",
        
        "inst_run": "Installation läuft...",
        "inst_part": "Partitionierung...",
        "inst_mount": "Dateisysteme einhängen...",
        "inst_copy": "Kopiere System...",
        "inst_conf": "Konfiguration...",
        "inst_fin": "Finalisierung...",
        "inst_boot": "Bootloader...",
        "inst_done": "Fertig!",
        "inst_fail": "Fehler aufgetreten!",
        
        "done_title": "Installation erfolgreich!",
        "done_desc": "Das System ist bereit zur Nutzung.",
        
        "user_name": "Benutzername",
        "user_pass": "Passwort",
        "user_root": "Root Passwort",
        "user_host": "Hostname",
        
        "modal_title": "Installation starten?",
        "modal_txt": "Die Festplatte wird bearbeitet. Fortfahren?",
        "err_title": "Fehler"
    },
    "en": {
        "btn_next": "Next",
        "btn_back": "Back",
        "btn_install": "Install",
        "btn_reboot": "Reboot",
        "btn_quit": "Quit",
        "step_welcome": "Welcome",
        "step_system": "System",
        "step_user": "User",
        "step_part": "Disk",
        "step_summary": "Summary",
        "step_install": "Install",
        "step_done": "Done",
        "wel_title": "Void Linux Installer",
        "wel_desc": "This wizard installs the current live system to your computer.",
        
        # NEW
        "sys_title": "System Configuration",
        "sys_desc": "Choose your system settings for language, timezone, and keyboard layout.",
        "sys_region": "Region & Language",
        "sys_lang": "System Language:",
        "sys_tz": "Timezone:",
        "sys_kbd_frame": "Keyboard",
        "sys_layout": "Layout:",
        
        "part_title": "Partitioning Method",
        "part_disk": "Target Disk:",
        "part_erase": "Erase Disk",
        "part_erase_desc": "Deletes all data and uses the whole disk.",
        "part_free": "Install alongside",
        "part_free_desc": "Uses unpartitioned space (Dual Boot).",
        "part_fs": "Filesystem:",
        "part_swap": "Swap Partition (8 GB)",
        "part_home": "Separate /home Partition",
        "part_warn": "WARNING: Data will be lost!",
        "sum_title": "Summary",
        "sum_dev": "Target Disk",
        "sum_mode": "Mode",
        "sum_fs": "Filesystem",
        "sum_user": "User",
        "sum_host": "Hostname",
        "inst_run": "Installation running...",
        "inst_part": "Partitioning...",
        "inst_mount": "Mounting...",
        "inst_copy": "Copying...",
        "inst_conf": "Configuring...",
        "inst_fin": "Finalizing...",
        "inst_boot": "Bootloader...",
        "inst_done": "Done!",
        "inst_fail": "Error occurred!",
        "done_title": "Installation successful!",
        "done_desc": "The system is ready to use.",
        "user_name": "Username",
        "user_pass": "Password",
        "user_root": "Root Password",
        "user_host": "Hostname",
        "modal_title": "Start Installation?",
        "modal_txt": "The disk will be modified. Continue?",
        "err_title": "Error"
    },
    "es": {
        "btn_next": "Siguiente",
        "btn_back": "Atrás",
        "btn_install": "Instalar",
        "btn_reboot": "Reiniciar",
        "btn_quit": "Salir",
        "step_welcome": "Bienvenido",
        "step_system": "Sistema",
        "step_user": "Usuario",
        "step_part": "Disco",
        "step_summary": "Resumen",
        "step_install": "Instalación",
        "step_done": "Listo",
        "wel_title": "Instalador Void Linux",
        "wel_desc": "Este asistente instalará el sistema actual.",
        
        # NEW
        "sys_title": "Configuración del sistema",
        "sys_desc": "Elija la configuración de idioma, zona horaria y teclado.",
        "sys_region": "Región e idioma",
        "sys_lang": "Idioma del sistema:",
        "sys_tz": "Zona horaria:",
        "sys_kbd_frame": "Teclado",
        "sys_layout": "Distribución:",
        
        "part_title": "Método de partición",
        "part_disk": "Disco de destino:",
        "part_erase": "Borrar disco",
        "part_erase_desc": "Elimina todos los datos.",
        "part_free": "Instalar junto a",
        "part_free_desc": "Usa espacio no particionado.",
        "part_fs": "Sistema de archivos:",
        "part_swap": "Swap (8 GB)",
        "part_home": "/home separada",
        "part_warn": "¡Se perderán datos!",
        "sum_title": "Resumen",
        "sum_dev": "Disco",
        "sum_mode": "Modo",
        "sum_fs": "Archivos",
        "sum_user": "Usuario",
        "sum_host": "Hostname",
        "inst_run": "Instalando...",
        "inst_part": "Particionando...",
        "inst_mount": "Montando...",
        "inst_copy": "Copiando...",
        "inst_conf": "Configurando...",
        "inst_fin": "Finalizando...",
        "inst_boot": "Cargador de arranque...",
        "inst_done": "¡Hecho!",
        "inst_fail": "¡Error!",
        "done_title": "¡Éxito!",
        "done_desc": "El sistema está listo.",
        "user_name": "Usuario",
        "user_pass": "Contraseña",
        "user_root": "Contraseña Root",
        "user_host": "Hostname",
        "modal_title": "¿Iniciar?",
        "modal_txt": "Se modificará el disco.",
        "err_title": "Error"
    },
    "fr": {
        "btn_next": "Suivant",
        "btn_back": "Retour",
        "btn_install": "Installer",
        "btn_reboot": "Redémarrer",
        "btn_quit": "Quitter",
        "step_welcome": "Bienvenue",
        "step_system": "Système",
        "step_user": "Utilisateur",
        "step_part": "Disque",
        "step_summary": "Résumé",
        "step_install": "Installation",
        "step_done": "Fini",
        "wel_title": "Installateur Void Linux",
        "wel_desc": "Cet assistant installe le système live actuel.",
        
        # NEW
        "sys_title": "Configuration du système",
        "sys_desc": "Choisissez les paramètres de langue, de fuseau horaire et de clavier.",
        "sys_region": "Région et langue",
        "sys_lang": "Langue du système :",
        "sys_tz": "Fuseau horaire :",
        "sys_kbd_frame": "Clavier",
        "sys_layout": "Disposition :",
        
        "part_title": "Partitionnement",
        "part_disk": "Disque cible :",
        "part_erase": "Effacer le disque",
        "part_erase_desc": "Supprime toutes les données.",
        "part_free": "Installer à côté",
        "part_free_desc": "Utilise l'espace libre.",
        "part_fs": "Système de fichiers :",
        "part_swap": "Swap (8 Go)",
        "part_home": "/home séparé",
        "part_warn": "ATTENTION : Perte de données !",
        "sum_title": "Résumé",
        "sum_dev": "Disque",
        "sum_mode": "Mode",
        "sum_fs": "Syst. fichiers",
        "sum_user": "Utilisateur",
        "sum_host": "Nom d'hôte",
        "inst_run": "Installation...",
        "inst_part": "Partitionnement...",
        "inst_mount": "Montage...",
        "inst_copy": "Copie...",
        "inst_conf": "Configuration...",
        "inst_fin": "Finalisation...",
        "inst_boot": "Chargeur d'amorçage...",
        "inst_done": "Terminé !",
        "inst_fail": "Erreur !",
        "done_title": "Succès !",
        "done_desc": "Le système est prêt.",
        "user_name": "Utilisateur",
        "user_pass": "Mot de passe",
        "user_root": "Mot de passe Root",
        "user_host": "Nom d'hôte",
        "modal_title": "Démarrer ?",
        "modal_txt": "Le disque sera modifié.",
        "err_title": "Erreur"
    }
}

def T(key):
    return STRINGS.get(CURRENT_LANG, STRINGS["en"]).get(key, STRINGS["en"].get(key, key))

def set_language(lang_code):
    global CURRENT_LANG
    if lang_code in STRINGS:
        CURRENT_LANG = lang_code