# 🧮 FinanzPlaner – Modernes Haushaltsbuch für Linux

Der **FinanzPlaner** ist ein modernes, elegantes Haushaltsbuch für Linux-Systeme.  
Entwickelt mit **GTK4 + libadwaita**, bietet es eine intuitive Bedienung, übersichtliche Auswertungen und eine starke Funktionsvielfalt – ideal für private Finanzen, Haushalte oder Selbstständige.

✨ **Designed by Pinguin-TV**  
🐧 Vollständig lokal, ohne Cloud  
🛡️ Datenschutzfreundlich: alle Daten bleiben auf deinem Rechner  

---

## 🚀 Funktionen

### 📊 Dashboard (Übersicht)
- Monatliche Einnahmen, Ausgaben & aktueller Saldo
- Donut-Chart „Ausgaben nach Kategorie“
- Balken-Charts „Ausgaben pro Monat“
- Top 5 Kategorien
- Größte 10 Ausgaben
- Finanzanalyse (automatische Auswertung mit Tipps)

### 💼 Transaktionen verwalten
- Einnahmen & Ausgaben erfassen
- Datum, Beschreibung, Betrag, Typ, Kategorie
- Automatische Kategorie-Vervollständigung
- Schnell-Kategorie-Buttons (Lebensmittel, Tanken, Haushalt …)
- Monats- & Kategorienfilter
- Bearbeiten & Löschen von Einträgen
- CSV-Import & CSV-Export

### 💰 Budgets & Auswertungen
- Monatliche Budgets pro Kategorie
- Ampelsystem (Grün/Orange/Rot)
- Live-Verbrauch pro Monat
- Übersicht aller Budgets

### 🔁 Wiederkehrende Buchungen (Abos)
- Intervalle in Monaten (Miete, Versicherungen, Streaming …)
- Automatisches Hinzufügen zum richtigen Datum
- Verwaltung & Löschung im UI

### 📚 Datenverwaltung
- SQLite-Datenbank (haushalt.db)
- Backup-Funktion (Auswahl beliebiges Laufwerk/Ordner)
- Restore-Funktion mit Sicherheitsabfrage
- Keine Cloud — alles bleibt lokal

### 🖨️ Monatsreport (PDF)
- Exportiere einen Monatsbericht mit:
  - Einnahmen, Ausgaben, Saldo
  - Kategorienübersicht
  - vollständige Transaktionsliste  
- PDF wird via *reportlab* generiert (optional)

### 🎨 Benutzeroberfläche
- Hell-/Dunkelmodus Umschalter
- Moderne libadwaita-Optik (GNOME Design Guidelines)
- Responsive Layout
- Card-Design, Hover-Effekte, Icon-Unterstützung
- Sauberes, einheitliches Farbschema

---

## 🛠️ Installation

### 🔹 1. Installationsscript

Starte im Projektverzeichnis:

```bash
chmod +x install.sh
./install.sh
