#!/bin/bash

# Konfiguration
APP_NAME="Arbeitszeiterfassung"
APP_DIR="/opt/arbeitszeit"
SOURCE_SCRIPT="zeit.py" # Name deiner Python-Datei im aktuellen Ordner
ICON_SOURCE="icons/logo.png"

# Farben für Output
GREEN='\033[0;32m'
RED='\033[0;31m'
NC='\033[0m' # No Color

# 1. Root-Rechte prüfen
if [ "$EUID" -ne 0 ]; then
  echo -e "${RED}Bitte als Root ausführen (sudo ./install.sh)${NC}"
  exit 1
fi

# 2. Prüfen ob Dateien existieren
if [ ! -f "$SOURCE_SCRIPT" ]; then
    echo -e "${RED}Fehler: $SOURCE_SCRIPT nicht gefunden! Bitte benenne deine Python-Datei in 'zeit.py' um oder passe das Skript an.${NC}"
    exit 1
fi

echo -e "${GREEN}--- Erkenne Linux-Distribution ---${NC}"
if [ -f /etc/os-release ]; then
    . /etc/os-release
    DISTRO=$ID
else
    echo "Konnte Distribution nicht erkennen."
    exit 1
fi

echo "Gefundene Distribution: $DISTRO"

# 3. Abhängigkeiten installieren
echo -e "${GREEN}--- Installiere Abhängigkeiten ---${NC}"

case $DISTRO in
    debian|ubuntu|linuxmint|pop)
        apt update
        apt install -y python3-gi python3-gi-cairo gir1.2-gtk-4.0 gir1.2-adw-1 python3-holidays python3-reportlab adwaita-icon-theme-full
        ;;
    fedora|rhel|centos)
        dnf install -y python3-gobject gtk4 libadwaita python3-holidays python3-reportlab adwaita-icon-theme
        ;;
    arch|manjaro|endeavouros)
        pacman -Sy --noconfirm python-gobject gtk4 libadwaita python-holidays python-reportlab adwaita-icon-theme
        ;;
    opensuse*|suse)
        zypper install -y python3-gobject gtk4 libadwaita typelib-1_0-Gtk-4_0 typelib-1_0-Adw-1 python3-holidays python3-reportlab adwaita-icon-theme
        ;;
    void)
        xbps-install -Sy python3-gobject gtk4 libadwaita python3-holidays python3-reportlab adwaita-icon-theme
        ;;
    solus)
        eopkg it -y python-gobject gtk4 libadwaita python-holidays python-reportlab adwaita-icon-theme
        ;;
    *)
        echo -e "${RED}Distribution '$DISTRO' wird vom Skript nicht automatisch unterstützt.${NC}"
        echo "Bitte installiere manuell: python3, gtk4, libadwaita, holidays, reportlab"
        read -p "Drücke Enter um trotzdem fortzufahren..."
        ;;
esac

# 4. Programmdateien kopieren
echo -e "${GREEN}--- Installiere Programm nach $APP_DIR ---${NC}"

# Verzeichnis erstellen
mkdir -p "$APP_DIR/icons"

# Dateien kopieren
cp "$SOURCE_SCRIPT" "$APP_DIR/main.py"
if [ -f "$ICON_SOURCE" ]; then
    cp "$ICON_SOURCE" "$APP_DIR/icons/logo.png"
else
    echo "Warnung: Logo nicht gefunden, überspringe."
fi

# Ausführbar machen
chmod +x "$APP_DIR/main.py"

# 5. Desktop Datei erstellen
echo -e "${GREEN}--- Erstelle Menü-Eintrag ---${NC}"

DESKTOP_FILE="/usr/share/applications/arbeitszeit.desktop"

cat > "$DESKTOP_FILE" <<EOF
[Desktop Entry]
Name=$APP_NAME
Comment=Stundenkonto und Urlaubsverwaltung
Exec=python3 $APP_DIR/main.py
Icon=$APP_DIR/icons/logo.png
Terminal=false
Type=Application
Categories=Office;Utility;
StartupNotify=true
EOF

# Icon Cache aktualisieren (versuchen)
if command -v gtk-update-icon-cache &> /dev/null; then
    gtk-update-icon-cache /usr/share/icons/hicolor &> /dev/null
fi

echo -e "${GREEN}--- Installation abgeschlossen! ---${NC}"
echo "Du findest die App jetzt im Startmenü unter 'Arbeitszeiterfassung'."